<?php

namespace App\Gates;

use App\Exceptions\ForbiddenException;

class PageGate
{
    public static function canToggleFavorite()
    {
        $user = auth()->user();
        if (!$user->plan->paid) {
            $message = "Adding or removing pages from favorites is only available on the paid plan.";
            throw new ForbiddenException($message, 1000);
        }
    }
}
