<?php

namespace App\Mail;

use App\Models\User;
use App\Repos\SettingRepo;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Queue\SerializesModels;

class Verify extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $appName;

    public function __construct(User $user)
    {
        $this->user = $user;
        $this->appName = SettingRepo::findByNameOrFail('app_name')->value;
    }

    public function envelope(): Envelope
    {
        $from = config('mail.from.address');
        return new Envelope(
            from: new Address($from, $this->appName),
            subject: "Access Your {$this->appName} Account",
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'mail.verify',
        );
    }
}
