<?php

namespace App\Models;

use App\Scopes\DailyCountBetweenDate;
use Illuminate\Database\Eloquent\Model;

class Colored extends Model
{
    use DailyCountBetweenDate;

    protected $fillable = [
        'user_id',
        'page_id',
        'photo',
        'preview',
    ];

    public function page()
    {
        return $this->belongsTo(Page::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
