<?php

namespace Database\Seeders;

use App\Models\Plan;
use App\Models\Subscription;
use App\Models\User;
use Illuminate\Database\Seeder;

class SubscriptionSeeder extends Seeder
{
    public function run(): void
    {
        $plans = Plan::all();
        $users = User::excludeAdmin()->get();
        foreach($plans as $plan) {
            foreach ($users as $user) {
                $count = rand(1, 3);
                Subscription::factory()
                    ->count($count)
                    ->create([
                        'user_id' => $user->id,
                        'plan_id' => $plan->id
                    ]);
            }
        }
    }
}
